//---------------------------------------------------------------------------------------------
// Torque Game Builder
// Copyright (C) GarageGames.com, Inc.
//---------------------------------------------------------------------------------------------
//
// This is the file you should define your custom datablocks that are to be used
// in the editor.
//

function setUpImageMaps()
{
	%dir0 = "Down";
	%dir1 = "Up";
	%dir2 = "Left";
	%dir3 = "Right";
	%dir4 = "UpRight";
	%dir5 = "UpLeft";
	%dir6 = "DownRight";
	%dir7 = "DownLeft";
	for(%i = 0; %i < 8; %i++)
	{
		%frame = 0;
		%dir = %dir[%i];
		while(isFile("game/data/images/player_" @ %dir @ %frame @ ".png"))
		{
			%name = "Player_" @ %dir @ %frame @ "ImageMap";
			new t2dImageMapDatablock(%name) {
					imageName = "~/data/images/player_" @ %dir @ %frame @ ".png";
					imageMode = "FULL";
					frameCount = "-1";
					filterMode = "NONE"; //SMOOTH
					filterPad = "0";
					preferPerf = "1";
					cellRowOrder = "1";
					cellOffsetX = "0";
					cellOffsetY = "0";
					cellStrideX = "0";
					cellStrideY = "0";
					cellCountX = "-1";
					cellCountY = "-1";
					cellWidth = "0";
					cellHeight = "0";
					preload = "1";
					allowUnload = "0";
					dir = %dir;
			 };
			 %frame++;
		 }
   }
}

new t2dImageMapDatablock(battleBackgroundImageMap) {
					imageName = "~/data/images/battleBackground.png";
					imageMode = "FULL";
					frameCount = "-1";
					filterMode = "SMOOTH";
					filterPad = "0";
					preferPerf = "1";
					cellRowOrder = "1";
					cellOffsetX = "0";
					cellOffsetY = "0";
					cellStrideX = "0";
					cellStrideY = "0";
					cellCountX = "-1";
					cellCountY = "-1";
					cellWidth = "0";
					cellHeight = "0";
					preload = "1";
					allowUnload = "0";
			 };
			 
			 new t2dImageMapDatablock(marker0ImageMap) {
					imageName = "~/data/images/marker0.png";
					imageMode = "FULL";
					frameCount = "-1";
					filterMode = "SMOOTH";
					filterPad = "0";
					preferPerf = "1";
					cellRowOrder = "1";
					cellOffsetX = "0";
					cellOffsetY = "0";
					cellStrideX = "0";
					cellStrideY = "0";
					cellCountX = "-1";
					cellCountY = "-1";
					cellWidth = "0";
					cellHeight = "0";
					preload = "1";
					allowUnload = "0";
			 };
			 
			 new t2dImageMapDatablock(marker1ImageMap) {
					imageName = "~/data/images/marker1.png";
					imageMode = "FULL";
					frameCount = "-1";
					filterMode = "SMOOTH";
					filterPad = "0";
					preferPerf = "1";
					cellRowOrder = "1";
					cellOffsetX = "0";
					cellOffsetY = "0";
					cellStrideX = "0";
					cellStrideY = "0";
					cellCountX = "-1";
					cellCountY = "-1";
					cellWidth = "0";
					cellHeight = "0";
					preload = "1";
					allowUnload = "0";
			 };
			 
			 new t2dImageMapDatablock(powerHitIndicatorImageMap) {
					imageName = "~/data/images/powerHitIndicator.png";
					imageMode = "FULL";
					frameCount = "-1";
					filterMode = "SMOOTH";
					filterPad = "0";
					preferPerf = "1";
					cellRowOrder = "1";
					cellOffsetX = "0";
					cellOffsetY = "0";
					cellStrideX = "0";
					cellStrideY = "0";
					cellCountX = "-1";
					cellCountY = "-1";
					cellWidth = "0";
					cellHeight = "0";
					preload = "1";
					allowUnload = "0";
			 };
			 
if(!isObject(GuiBattleHPProfile)) new GuiControlProfile (GuiBattleHPProfile)
{
   fontType = "Arial Bold";
   fontSize = 22;
   fontColor = "255 255 255";
};

if(!isObject(GuiMoveNameProfile)) new GuiControlProfile (GuiMoveNameProfile)
{
   fontType = "Arial Bold";
   fontSize = 22;
   fontColor = "255 255 255";
   justify = "center";
};

if(!isObject(GuiMoveNameSelectedProfile)) new GuiControlProfile (GuiMoveNameSelectedProfile)
{
   fontType = "Arial Bold";
   fontSize = 22;
   fontColor = "0 0 0";
   justify = "center";
};

if(!isObject(GuiStatProfile)) new GuiControlProfile (GuiStatProfile)
{
   fontType = "Arial Bold";
   fontSize = 24;
   fontColor = "255 255 255";
};

if(!isObject(GuiChatLineProfile)) new GuiControlProfile (GuiChatLineProfile)
{
   fontType = "Arial Bold";
   fontSize = 18;
   fontColor = "255 255 255";
};